<?php

/****************************************/
// :
// ==== : LogicBoard
// ==== :   (ShapeShifter)
// ==== Copyright     2011
// ====     
// ====  : http://logicboard.ru

/****************************************/

if (! defined ( 'LogicBoard' ))
{
	@include '../../logs/save_log.php';
	exit ( "Error, wrong way to file.<br><a href=\"/\">Go to main</a>." );
}

class LB_Template
{
	PUBLIC $dir = '.';
	PUBLIC $template = null;
	PUBLIC $copy_template = null;
	PUBLIC $data = array ();
	PUBLIC $tpl_out = array ();
	PUBLIC $block_data = array ();
	PUBLIC $result = array ('message' => '', 'speedbar' => '', 'content' => '' );
	PUBLIC $template_parse_time = 0;
	
	function tags($name, $var)
	{
		if( is_array( $var ) && count( $var ) )
		{
			foreach ( $var as $key => $key_var )
			{
				$this->tags( $key, $key_var );
			}
		}
		else
			$this->data[$name] = $var;
	}
    
    function tags_blocks($name = "", $opt = true, $opposide = false)
	{
		if (($opt AND !$opposide) OR (!$opt AND $opposide))
        {
            $this->tags( '['.$name.']', "" );
            $this->tags( '[/'.$name.']', "" ); 
        }
        else
            $this->block( "'\\[".$name."\\].*?\\[/".$name."\\]'si", "" );
	}
    	
    function global_tags($template)
	{
        global $cache_config, $secret_key;
                
		$this->result[$template] = str_replace ( '{TEMPLATE}', $cache_config['general_site']['conf_value'] . 'templates/'.$cache_config['template_name']['conf_value'], $this->result[$template] );
        $this->result[$template] = str_replace ( '{TEMPLATE_NAME}', $cache_config['template_name']['conf_value'], $this->result[$template] );
        $this->result[$template] = str_replace ( '{HOME_LINK}', $cache_config['general_site']['conf_value'], $this->result[$template] );
        $this->result[$template] = str_replace ( '{DLE_LINK}', $cache_config['general_site_dle']['conf_value'], $this->result[$template] );
        $this->result[$template] = str_replace ( '{SECRET_KEY}', $secret_key, $this->result[$template] );
    }
        	
	function block($name, $var)
	{
		if( is_array( $var ) && count( $var ) )
		{
			foreach ( $var as $key => $key_var )
			{
				$this->block( $key, $key_var );
			}
		}
		else
			$this->block_data[$name] = $var;
	}

	function load_template($tpl_name)
	{
		$time_before = $this->get_real_time();
		
		if( $tpl_name == '' OR ! file_exists( $this->dir . DIRECTORY_SEPARATOR . $tpl_name ) )
		{
            header( "Content-type: text/css; charset=windows-1251" );
			exit( "  : " . $tpl_name );
			return false;
		}

		$this->template = file_get_contents( $this->dir . DIRECTORY_SEPARATOR . $tpl_name );
	
		if (strpos ( $this->template, "[global_group=" ) !== false)
        {
			$this->template = preg_replace ( "#\\[global_group=(.+?)\\](.*?)\\[/global_group\\]#ies", "\$this->check_group('\\1', '\\2')", $this->template );
		}
		if (strpos ( $this->template, "[global_not_group=" ) !== false)
        {
			$this->template = preg_replace ( "#\\[global_not_group=(.+?)\\](.*?)\\[/global_not_group\\]#ies", "\$this->check_group('\\1', '\\2', false)", $this->template );
		}
        
		$this->copy_template = $this->template;
        
        $this->tpl_out['templates'][] = $tpl_name;
        
		$this->template_parse_time += $this->get_real_time() - $time_before;
		return true;
	}

	function check_group($groups, $block, $available = true)
	{
		global $member_id;
		
		$groups = explode( ',', $groups );
		if( $available )
        {
			if(!in_array($member_id['user_group'], $groups))
                return "";
		}
        else
        {
			if(in_array($member_id['user_group'], $groups))
                return "";
		}
		$block = str_replace( '\"', '"', $block );
		
		return $block;
	}
	
	function _clear()
	{
		$this->data = array ();
		$this->block_data = array ();
		$this->copy_template = $this->template;
	}
	
	function clear()
	{
		$this->data = array ();
		$this->block_data = array ();
		$this->copy_template = null;
		$this->template = null;
	}
	
	function global_clear()
	{
		$this->data = array ();
		$this->block_data = array ();
		$this->result = array ();
		$this->copy_template = null;
		$this->template = null;
	}
	
	function compile($tpl)
	{
	    global $pravAvtota, $cache_config, $cache_group, $member_id;
		$time_before = $this->get_real_time();

        $find = array();
        $replace = array();

		if( count( $this->block_data ) )
		{
			foreach ( $this->block_data as $key_find => $key_replace )
			{
				$find_preg[] = $key_find;
				$replace_preg[] = $key_replace;
			}
			$this->copy_template = preg_replace( $find_preg, $replace_preg, $this->copy_template );
		}
		
		foreach ( $this->data as $key_find => $key_replace )
		{
			$find[] = $key_find;
			$replace[] = $key_replace;
		}
        
        $this->copy_template = str_replace( $find, $replace, $this->copy_template );
                                                
        eval(base64_decode('DQogICAgICAgICR0aGlzLT5jb3B5X3RlbXBsYXRlID0gc3RyX3JlcGxhY2UoICRmaW5kLCAkcmVwbGFjZSwgJHRoaXMtPmNvcHlfdGVtcGxhdGUgKTsNCiAgICAgICAgDQogICAgICAgIGlmICgkdHBsID09ICJnbG9iYWxfdGVtcGxhdGUiIEFORCAoKCRjYWNoZV9jb25maWdbJ2dlbmVyYWxfY2xvc2UnXVsnY29uZl92YWx1ZSddIEFORCAkY2FjaGVfZ3JvdXBbJG1lbWJlcl9pZFsndXNlcl9ncm91cCddXVsnZ19zaG93X2Nsb3NlX2YnXSA9PSAxKSBPUiAhJGNhY2hlX2NvbmZpZ1snZ2VuZXJhbF9jbG9zZSddWydjb25mX3ZhbHVlJ10pKQ0KICAgICAgICB7DQogICAgICAgICAgICBpZiAoJHByYXZBdnRvdGEgIT0gIjxhIGhyZWY9XCJodHRwOi8vbG9naWNib2FyZC5ydS9cIiB0YXJnZXQ9XCJibGFua1wiPkxvZ2ljQm9hcmQ8L2E+IikNCiAgICAgICAgICAgICAgICBleGl0ICgiUmV0dXJuIHRoZSBjb3B5cmlnaHQgTG9naWNCb2FyZDIhIik7DQogICAgICAgICAgICANCiAgICAgICAgICAgIGlmICghcHJlZ19tYXRjaCgiI3tjb3B5cmlnaHR9IyIsICR0aGlzLT5jb3B5X3RlbXBsYXRlKSkNCiAgICAgICAgICAgICAgICBleGl0ICgiUmV0dXJuIHRoZSBjb3B5cmlnaHQgTG9naWNCb2FyZDMhIik7DQogICAgICAgICAgICBlbHNlDQogICAgICAgICAgICAgICAgJHRoaXMtPmNvcHlfdGVtcGxhdGUgPSBzdHJfcmVwbGFjZSggIntjb3B5cmlnaHR9IiwgJHByYXZBdnRvdGEsICR0aGlzLT5jb3B5X3RlbXBsYXRlICk7DQoJCX0NCiAgICAgICAgDQogICAgICAgIGlmKCBpc3NldCggJHRoaXMtPnJlc3VsdFskdHBsXSApICkNCgkJCSR0aGlzLT5yZXN1bHRbJHRwbF0gLj0gJHRoaXMtPmNvcHlfdGVtcGxhdGU7DQoJCWVsc2UNCgkJCSR0aGlzLT5yZXN1bHRbJHRwbF0gPSAkdGhpcy0+Y29weV90ZW1wbGF0ZTsNCiAgICAgICAg'));
		
        $this->tpl_out['compile'][] = $tpl;
                
		$this->_clear();
		
		$this->template_parse_time += $this->get_real_time() - $time_before;
	}
    
	function get_real_time()
	{
		list ( $seconds, $microSeconds ) = explode( ' ', microtime() );
		return (( float ) $seconds + ( float ) $microSeconds);
	}
}

?>